(function()
{
    /**
     * This utility file will generate an extendscript file with the binary encoded strings of 
     * specified resource files when run. 
     * It's designed to allow you to setup your project, select the files you want to embed, and 
     * have the binary embedding process done for you
     */

    // The path to the project Root(URI)
    var projectRoot = "/W/PluginEverything/013_Benchmark/00_dev/src/"
    var binaryOutputPath = "jsx/resources.jsx";

    /**
     * The JSON like structure of your resources, simply give it a name and a folder path relative to
     * the root of this project and a description if you want
     * 
     * @type {Object.<string, {relativePath: string, description?: string}>}
     */
    var resourceMap = {
        aeProject: {
            relativePath: "jsx_resources/Benchmark.aep",
            description: "The Hex representation of the binary of the Benchmark Project file\nThis is embedded as a string so it can be written to a temporary location at runtime and loaded without allowing the user to easily modify the project file and increase their score"
        }
    };

    /** @type {string[]} */
    var embeddedResources = [];

    // Generating binary strings
    for(var key in resourceMap) {
        // Getting the File object for the resource
        var resFile = new File(projectRoot + resourceMap[key].relativePath);

        // Checking to make sure it exists
        if(!resFile.exists) {
            alert("Error\nResource file does not exist\n" + resFile.fsName);
            continue;
        }

        // Open and set the coding
        resFile.open("r");
        resFile.encoding = "binary";

        // Getting a buffer to read the file contents into and converting to it's source
        var buffer = resFile.read();
        /** @type {string} */ ///@ts-ignore
        var source = buffer.toSource();

        // Closing the file
        resFile.close();

        // Now we need to remove the excess on the source string
        /*var trimStart = source.indexOf("\"");   // Getting the first qoutation mark, "
        var trimEnd = source.lastIndexOf("\"))"); // Getting the last qoutation mark, "
        source = source.substr(trimStart+1, trimEnd);*/
        source = source.substring(13, source.length - 3);
        
        // Generating description
        var description = resourceMap[key].description.replace(/^/gm, " * ");
        var description = "/**\n" + description + "\n */";

        // Generating the embedded line
        var embed = description + "\nRESOURCES." + key + " = \"" + source + "\";";
        embeddedResources.push(embed);
    }


    // Now we generate the file source code    
    var fileSource = "var RESOURCES = {}\n\n" + embeddedResources.join("\n\n");

    // And write it
    var codeFile = new File(projectRoot + binaryOutputPath);
    codeFile.open("w");
    codeFile.write(fileSource);
    codeFile.close();
})();